public class DataMat {
	public double[][] data;
	private int az = 1, as = 1;
	final private static int MAX_SIZE = 1_310_720; // Die Array-Größe wird beschränkt auf 10 MB.
	
	public DataMat(int z, int s) {
		if (z >= 1  &&  s >= 1  &&  z * s  <= MAX_SIZE) {
			az = z;
			as = s;
		} else {
			IO.println("\nWegen Zeilen < 1, Spalten < 1 oder Speicherbedarf > " + MAX_SIZE +
                               " wurde Zeilen = Spalten = 1 gesetzt");
		}
		data = new double[az][as];
	}

	public int anz() {return data.length;}

	public int ans() {return data[0].length;}
		
	public void show() {
		for (int i = 0; i < az; i++) {
			for (int j = 0; j < as; j++)
				System.out.printf("%8.2f ", data[i][j]);
			IO.println();
			}
		IO.println();
	}

	public void flip() {
		if (az == as) {
			double buffer;
			for (int i = 0; i < az; i++)
				for (int j = 0; j < i; j++) {
					buffer = data[i][j];
					data[i][j] = data[j][i];
					data[j][i] = buffer;
				}
		} else {
			int temp = az;
			az = as;
			as = temp;
			double ndata[][] = new double[az][as];
			for (int i = 0; i < az; i++)
				for (int j = 0; j < as; j++)
					ndata[i][j] = data[j][i];
			data = ndata;
		}
	}

	public double[] mean() { 
		if (data.length < 1)
			return null;
		double sum[] = new double[as];
		for (int j = 0; j < as; j++ ) {
			for (int i = 0; i < az; i++)
				sum[j] += data[i][j];
			sum[j] /= az;
		}
		return sum;
	} 

	public double[] variance() { 
		if (data.length < 2)
			return null;
		double sum[] = new double[as];
		double qs[] = new double[as];
		for (int j = 0; j < as; j++ ) {
			for (int i = 0; i < az; i++) {
				sum[j] += data[i][j];
				qs[j] += data[i][j] * data[i][j];
			}
			qs[j] = (qs[j] - (sum[j]*sum[j]/az)) / (az-1);
		}
		return qs;
	} 
}